import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/model/request/all_request_response_model.dart';
import 'package:play_lab/data/model/request/my_request_response_modell.dart';
import 'package:play_lab/data/model/request/request_model.dart';
import 'package:play_lab/data/model/request/request_update_response.dart';
import 'package:play_lab/data/repo/request/request_repo.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

class RequestController extends GetxController {
  RequestRepo repo;
  RequestController({required this.repo});

  bool isLoading = false;
  List<RequestItem> allRequests = [];
  List<RequestItem> myRequests = [];
  int currentPage = 0;
  String? nextPageUrl;
  String imagePath = "";

  void clear() {
    myRequests = [];
    currentPage = 0;
    nextPageUrl = null;
    isLoading = false;
    update();
  }

  Future<void> myRequestList() async {
    if (currentPage == 0) {
      myRequests = [];
      isLoading = true;
      nextPageUrl = null;
    } else {
      isLoading = false;
    }
    currentPage++;
    update();
    try {
      ResponseModel responseModel = await repo.myRequest(currentPage.toString());
      if (responseModel.statusCode == 200) {
        MyRequestResponseModel myRequestResponseModel = myRequestResponseModelFromJson(responseModel.responseJson);
        printX("myRequestResponseModel.status ${myRequestResponseModel.data?.data?.nextPageUrl}");
        if (myRequestResponseModel.status == "success") {
          myRequests.addAll(myRequestResponseModel.data?.data?.data ?? []);
          imagePath = myRequestResponseModel.data?.imagePath ?? "";
          nextPageUrl = myRequestResponseModel.data?.data?.nextPageUrl;
          isLoading = false;
          update();
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: myRequestResponseModel.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      printX("ERROR:");
      printX(e);
    }
    isLoading = false;
    update();
  }

  Future<void> allRequestList() async {
    if (currentPage == 0) {
      clear();
      isLoading = true;
    } else {
      isLoading = false;
    }
    currentPage++;
    update();
    try {
      ResponseModel responseModel = await repo.allRequest(currentPage.toString());
      if (responseModel.statusCode == 200) {
        final model = allRequestResponseModelFromJson(responseModel.responseJson);
        if (model.status == "success") {
          allRequests.addAll(model.data?.items ?? []);
          imagePath = model.data?.imagePath ?? "";
          nextPageUrl = model.data?.pagination?.nextPageUrl;
          isLoading = false;
          update();
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      isLoading = false;
      update();
    }
  }

  Future<void> vote(int index, {bool isUpVote = true, bool myRequest = false}) async {
    printX(myRequest ? myRequests[index].id : allRequests[index].id);
    try {
      ResponseModel responseModel = await repo.voteNSubscribe(
        isVote: true,
        body: {"track_id": myRequest ? myRequests[index].id : allRequests[index].id, "vote_type": isUpVote ? "upvote" : "downvote"},
      );
      final model = requestUpdateResponseModelFromJson(responseModel.responseJson);
      if (model.status == "success") {
        if (myRequest) {
          myRequests[index] = myRequests[index].copyWith(upVotes: model.data?.upvotes, downVotes: model.data?.downvotes);
        } else {
          allRequests[index] = allRequests[index].copyWith(upVotes: model.data?.upvotes, downVotes: model.data?.downvotes);
        }
        update();
      } else {
        //
      }
    } catch (e) {
      printX(e);
    }
  }

  Future<void> subscribe(int index, {bool myRequest = false}) async {
    printX(myRequests[index].id);
    try {
      ResponseModel responseModel = await repo.voteNSubscribe(isVote: false, body: {"item_id": myRequest ? myRequests[index].id : allRequests[index].id});
      final model = requestUpdateResponseModelFromJson(responseModel.responseJson);
      if (model.status == "success") {
        if (myRequest) {
          myRequests[index] = myRequests[index].copyWith(userSubscribe: model.data?.subscribed);
        } else {
          allRequests[index] = allRequests[index].copyWith(userSubscribe: model.data?.subscribed);
        }
        update();
      } else {
        //
      }
    } catch (e) {
      printX(e);
    }
  }

  bool hasNext() {
    return nextPageUrl != null && nextPageUrl!.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }
}
